﻿using UnityEngine;
using System.Collections;
using UnityEditor;

[CustomEditor(typeof(AnimalAI))]

public class AnimalAIEditor : Editor 
{

	AnimalAI myScript;

	void OnEnable()
	{
		myScript = (AnimalAI)target; 
	}

	public override void OnInspectorGUI()
	{
		EditorGUILayout.HelpBox("Animal AI is an awesome script that Adrian made. \n\n-To make the critter always Idle it must have zero WayPoints. \n-Idle and Run Probabilities are evaluated when the animal reaches a checkpoint. \n-For best results avoid short distances between WayPoints and sharp turns.\n-DON'T DELETE THE CHECKPOINTS FROM HIERARCHY - INSTEAD USE THE BUTTONS BELLOW", MessageType.None, true);



		if(GUILayout.Button("Add Waypoint"))
		{
			GenerateWaypoints();
		}

		if (myScript._wayPointsList.Count > 0) GUI.enabled = true;
		else GUI.enabled = false;
		if(GUILayout.Button("Delete Waypoint"))
		{
			DeleteWaypoint();
		}

		if(GUILayout.Button("Delete All Waypoints!"))
		{
			DeleteAllWaypoints();
		}

		if(GUILayout.Button("Randomize Waypoints!"))
		{
			myScript.RandomizeWaypointPosition();
		}

		GUI.enabled = true;
		myScript.idleProbability = EditorGUILayout.Slider ("Idle Probability", myScript.idleProbability, 0, 1);
		myScript.runProbability = EditorGUILayout.Slider ("Run Probability", myScript.runProbability, 0, 1);

		DrawDefaultInspector();
		EditorUtility.SetDirty(myScript);
	}

	public void GenerateWaypoints ()
	{
		myScript.GenerateWaypoints();

		EditorUtility.SetDirty(myScript);
	}

	public void DeleteWaypoint ()
	{
		Debug.Log("Delete Waypoint");
		DestroyImmediate(myScript._wayPointsList[myScript._wayPointsList.Count-1].gameObject);
		myScript._wayPointsList.RemoveAt(myScript._wayPointsList.Count-1);
		
		myScript._wayPointNr --;
		if (myScript._wayPointGenOffset > 0) myScript._wayPointGenOffset --;
		EditorUtility.SetDirty(myScript);
	}

	public void DeleteAllWaypoints ()
	{
		Debug.Log("Delete ALL Waypoints");
		for (var i = 0; i < myScript._wayPointsList.Count; i++)
		{
			DestroyImmediate(myScript._wayPointsList[i].gameObject);
		}
		
		myScript._wayPointsList.Clear();
		myScript._wayPointNr = 0;
		myScript._wayPointGenOffset = 0;
		EditorUtility.SetDirty(myScript);
	}
}
